/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.util.Hashtable;

public final class VWWorkBasketColumnDefinition
extends VWMLABase
implements Serializable,
Cloneable,
IVWtoXML {
    private static final long serialVersionUID = 7440L;
    protected transient VWWorkBasketDefinition m_myWorkBasketDef = null;
    protected String m_prompt = null;
    private VWExposedFieldDefinition m_column = null;
    private boolean m_bIsSortable = false;
    private String m_indexName = null;
    private String m_ORBColumnName = null;
    private int m_fieldType = -1;
    protected Hashtable m_attributes = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:20:42 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/3 $";
    }

    protected VWWorkBasketColumnDefinition(String prompt, VWExposedFieldDefinition column, VWWorkBasketDefinition workBasketDef) throws VWException {
        this.internalSetPrompt(prompt);
        if (workBasketDef == null) {
            throw new VWException("vw.api.VWWorkBasketColumnDefErr", "The in-basket definition object can not be null");
        }
        this.setMyWorkBasketDefinition(workBasketDef);
        if (column == null) {
            throw new VWException("vw.api.VWWorkBasketColumnDefErr", "The field definition object for column can not be null");
        }
        this.m_column = column;
        this.setHasChanged(true);
    }

    protected VWWorkBasketColumnDefinition(String prompt, VWExposedFieldDefinition column, boolean bIsSortable, String indexName, VWAttributeInfo attributes) throws VWException {
        this.internalSetPrompt(prompt);
        this.m_column = column;
        this.m_bIsSortable = bIsSortable;
        this.m_indexName = indexName;
        this.setAttributeInfo(attributes);
    }

    protected VWWorkBasketColumnDefinition(String prompt, String orbColumnName, boolean bIsSortable, String indexName, VWAttributeInfo attributes) throws VWException {
        this.internalSetPrompt(prompt);
        this.m_ORBColumnName = orbColumnName;
        this.m_bIsSortable = bIsSortable;
        this.m_indexName = indexName;
        this.setAttributeInfo(attributes);
    }

    protected void setMyWorkBasketDefinition(VWWorkBasketDefinition wbDef) throws VWException {
        this.m_myWorkBasketDef = wbDef;
        if (wbDef != null) {
            super.setSession(wbDef.getSession());
        }
    }

    public String getName() throws VWException {
        if (this.m_column != null) {
            return this.m_column.getName();
        }
        return this.translateStr(this.m_ORBColumnName);
    }

    public String getAuthoredName() throws VWException {
        if (this.m_column != null) {
            return this.m_column.getAuthoredName();
        }
        return this.translateToAuthored(this.m_ORBColumnName);
    }

    public String getPrompt() throws VWException {
        String prompt = null;
        if (this.m_prompt != null) {
            prompt = this.m_prompt;
        } else if (this.m_column != null && (prompt = this.m_column.getPrompt()) == null) {
            prompt = this.m_column.getName();
        }
        if (prompt != null) {
            return this.translateStr(prompt);
        }
        return null;
    }

    public void setPrompt(String thePrompt) throws VWException {
        if (thePrompt != null) {
            thePrompt = thePrompt.trim();
        }
        if (thePrompt == null || thePrompt.length() == 0) {
            throw new VWException("vw.api.VWWorkBasketColumnDefinitionInvalidPrompt", "Failed to set the in-basket column prompt - it can not be null or empty");
        }
        if (thePrompt.equals(this.m_prompt)) {
            return;
        }
        this.m_prompt = thePrompt;
        this.setHasChanged(true);
    }

    private void internalSetPrompt(String thePrompt) {
        if (thePrompt != null && (thePrompt = thePrompt.trim()).length() == 0) {
            thePrompt = null;
        }
        this.m_prompt = thePrompt;
    }

    public boolean isSortable() throws VWException {
        return this.m_bIsSortable;
    }

    public void setSortable(boolean bIsSortable) {
        this.m_bIsSortable = bIsSortable;
    }

    public int getType() throws VWException {
        if (this.m_fieldType != -1) {
            return this.m_fieldType;
        }
        if (this.m_column != null) {
            return this.m_column.getFieldType();
        }
        return -1;
    }

    public VWExposedFieldDefinition getColumn() throws VWException {
        return this.m_column;
    }

    public void setColumn(VWExposedFieldDefinition column) throws VWException {
        if (column == null) {
            throw new VWException("vw.api.VWWorkBasketColumnDefNullColumn", "The field definition object for in-basket column can not be null");
        }
        this.m_column = column;
        this.setHasChanged(true);
    }

    public String getIndexName() throws VWException {
        if (this.m_indexName != null && this.m_indexName.trim().length() == 0) {
            return null;
        }
        return this.translateStr(this.m_indexName);
    }

    public void setIndexName(String indexName) throws VWException {
        if (indexName != null) {
            if ((indexName = indexName.trim()).length() == 0) {
                indexName = null;
            } else if (this.m_myWorkBasketDef != null && this.m_myWorkBasketDef.m_myQueueDef != null) {
                if (this.m_myWorkBasketDef.m_myQueueDef.getIndex(indexName) == null) {
                    throw new VWException("vw.api.VWWorkBasketColumnDefinition.IndexDoesNotExist", "Failed to set the index name - the index does not exist in the queue.");
                }
            } else {
                throw new VWException("vw.api.VWWorkBasketColumnDefinition.nullQueueOrWorkBasket", "Failed to set the index name - the in-basket definition object and the queue definition objects can not be null");
            }
        }
        this.m_indexName = indexName;
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.m_attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        Hashtable theAttributes;
        this.m_attributes = theAttributeInfo != null ? (theAttributes = theAttributeInfo.attributes) : null;
        this.setHasChanged(true);
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.m_attributes = theAttributes;
    }

    public String toString() {
        if (this.m_column != null) {
            return this.m_column.getName();
        }
        if (this.m_prompt != null) {
            return this.m_prompt;
        }
        return "";
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void setHasChanged(boolean theNewValue) throws VWException {
        if (this.m_myWorkBasketDef != null) {
            this.m_myWorkBasketDef.setHasChanged(theNewValue);
        }
    }

    protected Object clone() {
        try {
            VWWorkBasketColumnDefinition workBasketColumnDef = (VWWorkBasketColumnDefinition)super.clone();
            if (this.m_attributes != null) {
                workBasketColumnDef.m_attributes = (Hashtable)this.m_attributes.clone();
            }
            return workBasketColumnDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void initColumnFromOrb() throws VWException {
        if (this.m_myWorkBasketDef.m_myQueueDef != null && this.m_ORBColumnName != null && this.m_ORBColumnName.length() > 0) {
            this.m_column = this.m_myWorkBasketDef.m_myQueueDef.getExposedField(this.m_ORBColumnName);
            this.m_ORBColumnName = null;
        }
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWorkBasketColumnDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        theBuffer.append(INDENT_0 + "<" + "InBasketColumnDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Prompt" + "=\"" + VWXMLHandler.toXMLString(this.m_prompt) + "\"\n");
        theBuffer.append(INDENT_1 + "IndexName" + "=\"" + VWXMLHandler.toXMLString(this.m_indexName) + "\"\n");
        if (this.m_column != null) {
            theBuffer.append(INDENT_1 + "Column" + "=\"" + VWXMLHandler.toXMLString(this.m_column.getName()) + "\"\n");
        }
        theBuffer.append(INDENT_1 + "Sortable" + "=\"" + this.m_bIsSortable + "\"");
        theBuffer.append(">\n");
        VWAttributeInfo theAttributeInfo = this.getAttributeInfo();
        theAttributeInfo.toXML(theBuffer, INDENT_1);
        theBuffer.append(INDENT_0 + "</" + "InBasketColumnDefinition" + ">\n");
    }

    protected void removeReferences() {
        this.m_prompt = null;
        this.m_myWorkBasketDef = null;
        this.m_column = null;
        this.m_indexName = null;
        if (this.m_attributes != null) {
            this.m_attributes.clear();
        }
        this.m_attributes = null;
    }

    protected void setType(int fieldType) {
        this.m_fieldType = fieldType;
    }
}

